using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Utils;

namespace BeWise.SharpBuilderTools.Gui
{
	public class FrmClipboardViewer : System.Windows.Forms.Form
	{
		/**************************************************************/
		/*                    Constructor/ Destructor
		/**************************************************************/

		public FrmClipboardViewer()
		{
			InitializeComponent();
			InitializeListView(lvItems);
		}

		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		/**************************************************************/
		/*                         Private
		/**************************************************************/

		private ArrayList fItems = null;
		private System.Windows.Forms.Button btCopy;
		private System.Windows.Forms.TextBox txtValue;

		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btCancel;
		private System.Windows.Forms.TabControl TabControl;
		private System.Windows.Forms.TabPage tabPage1;
		private System.Windows.Forms.ListView lvItems;

		private void txtItem_TextChanged(object sender, System.EventArgs e) {
			LoadItemsInListView();
		}

		private void FrmBaseView_Enter(object sender, System.EventArgs e) {
			lvItems.Focus();
		}
		
		private void lvItems_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (lvItems.SelectedItems.Count > 0) {
				txtValue.Text = (string) lvItems.SelectedItems[0].Tag;
			} else {
				txtValue.Text = "";
			}
		}

		private void btCopy_Click(object sender, System.EventArgs e)
		{
			if (lvItems.SelectedItems.Count > 0) {
				Clipboard.SetDataObject(lvItems.SelectedItems[0].Text);
			}
			
			Close();
		}

		private void InitializeComponent()
		{
			this.btCancel = new System.Windows.Forms.Button();
			this.TabControl = new System.Windows.Forms.TabControl();
			this.tabPage1 = new System.Windows.Forms.TabPage();
			this.txtValue = new System.Windows.Forms.TextBox();
			this.lvItems = new System.Windows.Forms.ListView();
			this.btCopy = new System.Windows.Forms.Button();
			this.TabControl.SuspendLayout();
			this.tabPage1.SuspendLayout();
			this.SuspendLayout();
			// 
			// btCancel
			// 
			this.btCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btCancel.Location = new System.Drawing.Point(432, 304);
			this.btCancel.Name = "btCancel";
			this.btCancel.TabIndex = 2;
			this.btCancel.Text = "Cancel";
			// 
			// TabControl
			// 
			this.TabControl.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.TabControl.Controls.Add(this.tabPage1);
			this.TabControl.Location = new System.Drawing.Point(8, 8);
			this.TabControl.Name = "TabControl";
			this.TabControl.SelectedIndex = 0;
			this.TabControl.Size = new System.Drawing.Size(504, 288);
			this.TabControl.TabIndex = 0;
			this.TabControl.TabStop = false;
			// 
			// tabPage1
			// 
			this.tabPage1.Controls.Add(this.txtValue);
			this.tabPage1.Controls.Add(this.lvItems);
			this.tabPage1.Location = new System.Drawing.Point(4, 22);
			this.tabPage1.Name = "tabPage1";
			this.tabPage1.Size = new System.Drawing.Size(496, 262);
			this.tabPage1.TabIndex = 0;
			this.tabPage1.Text = "Clipboard";
			// 
			// txtValue
			// 
			this.txtValue.Location = new System.Drawing.Point(8, 144);
			this.txtValue.Multiline = true;
			this.txtValue.Name = "txtValue";
			this.txtValue.ReadOnly = true;
			this.txtValue.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.txtValue.Size = new System.Drawing.Size(480, 112);
			this.txtValue.TabIndex = 1;
			this.txtValue.Text = "";
			// 
			// lvItems
			// 
			this.lvItems.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.lvItems.FullRowSelect = true;
			this.lvItems.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvItems.HideSelection = false;
			this.lvItems.Location = new System.Drawing.Point(8, 8);
			this.lvItems.MultiSelect = false;
			this.lvItems.Name = "lvItems";
			this.lvItems.Size = new System.Drawing.Size(480, 128);
			this.lvItems.TabIndex = 0;
			this.lvItems.SelectedIndexChanged += new System.EventHandler(this.lvItems_SelectedIndexChanged);
			// 
			// btCopy
			// 
			this.btCopy.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btCopy.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btCopy.Location = new System.Drawing.Point(352, 304);
			this.btCopy.Name = "btCopy";
			this.btCopy.TabIndex = 1;
			this.btCopy.Text = "Copy";
			this.btCopy.Click += new System.EventHandler(this.btCopy_Click);
			// 
			// FrmClipboardViewer
			// 
			this.AcceptButton = this.btCopy;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btCancel;
			this.ClientSize = new System.Drawing.Size(520, 334);
			this.Controls.Add(this.btCopy);
			this.Controls.Add(this.TabControl);
			this.Controls.Add(this.btCancel);
			this.Name = "FrmClipboardViewer";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Clipboard Viewer";
			this.Enter += new System.EventHandler(this.FrmBaseView_Enter);
			this.TabControl.ResumeLayout(false);
			this.tabPage1.ResumeLayout(false);
			this.ResumeLayout(false);
		}

        /**************************************************************/
		/*                       Protected
		/**************************************************************/

		protected ListViewItem CreateListViewItem(object aItem) {
			ListViewItem _ListViewItem = new ListViewItem();

			StringReader  _Reader = new StringReader((string) aItem);
			string _Line = _Reader.ReadLine();

			if ((aItem as string).Length > _Line.Length) {
				_Line += " [...]";
			}
			
			_ListViewItem.Text = _Line;
			_ListViewItem.Tag = (string) aItem;

			return _ListViewItem;
		}

		protected virtual void InitializeListView(ListView aListView) {
			ColumnHeader _Col = new ColumnHeader();
			_Col.Text = "Names";
			_Col.Width = lvItems.Width -4;

			lvItems.Columns.Add(_Col);
			lvItems.View = View.Details;
		}

		/**************************************************************/
		/*                         Public
		/**************************************************************/

		public void LoadItemsInListView() {
			lvItems.BeginUpdate();
			try {
				lvItems.Items.Clear();

				for (int i = 0; i < fItems.Count; i ++) {
					ListViewItem _Item = CreateListViewItem(fItems[i]);
					lvItems.Items.Add(_Item);
				}
			}
			finally {
				lvItems.EndUpdate();
			}
		}

		/**************************************************************/
		/*                       Properties
		/**************************************************************/

		public ArrayList Items {
			get {
				return fItems;
			}

			set {
				fItems = value;
				LoadItemsInListView();
			}
		}
	}
}
